import React, {useEffect, useState} from 'react';
import CardDetail from '../components/CardDetail'
import {Box, Modal} from "@mui/material";
import FormData from "../components/FormData";
import ModalForm from "../components/ModalForm";
import {useParams} from "react-router-dom";
import axios from "axios";

const Details = () => {

  const [open, setOpen] = useState(false);
  const handleOpen = () => setOpen(true);
  const handleClose = () => setOpen(false);

  const {id} = useParams()
  const url = 'https://ooxvks6089.execute-api.eu-south-1.amazonaws.com/dev/test/facility/' +id
  const [detail, setDetail]=useState([])



  useEffect(()=>{
    const getDetails = async () => {
      const response = await axios.get(url)
      setDetail(response.data)
    }
    getDetails()
  },[])

  return (
    <div>
      <CardDetail handleOpen={handleOpen} detail={detail}/>
      <ModalForm open={open} handleClose={handleClose} detail={detail} url={url}/>
    </div>
  );
};

export default Details;
