import React, {useEffect, useState} from 'react';
import {Box, Button, FormControl, TextField} from "@mui/material";
import axios from "axios";

/*
* Prendere i valori in input | fatto
* settare i valori vecchi con uno use state e passargli quelli nuovi | fatto
* richiamare onchange | fatto
* Settare il default.value con i dati del DETAIL( fatto)
*
* Al click del submit devo salvare i nuovi valori inseriti in input
* */

function FormData({detail, url}) {
  //Setto lo use state
  const [name, setName] = useState(detail.name)
  const [address, setAddress] = useState(detail.address)
  const [city, setCity] = useState(detail.city)
  const [zip, setZip] = useState(detail.zip_code)
  const [district, setDistrict] = useState(detail.district)
  const [region, setRegion] = useState(detail.region)
  const [phone, setPhone] = useState(detail.phone)
  const [note, setNote] = useState(detail.note)

//Funzione al submit
  const handleSubmit = (e)=> {
    e.preventDefault()
    axios.put(url, {
      name,
      address,
      city,
      zip,
      district,
      region,
      phone,
      note
    }).then(response => {
      console.log(response)
    })
   /* console.log('ciao')*/

  }
  console.log(url)

  return (
    <div>
      <FormControl onSubmit={handleSubmit}
        component="form"
        sx={{
          '& .MuiTextField-root': { m: 1, width: '25ch' },
        }}
        noValidate
        autoComplete="off"
      >
        <div>
          <TextField
            onChange={(e)=> setName(e.target.value)}
            id="outlined-error"
            label="name"
            defaultValue={detail.name}
          />
          <TextField
            onChange={(e)=> setAddress(e.target.value)}
            id="outlined-error"
            label="address"
            defaultValue={detail.address}
          />
        </div>
        <div>
          <TextField
            onChange={(e)=> setCity(e.target.value)}
            id="outlined-error"
            label="city"
            defaultValue={detail.city}
          />
          <TextField
            onChange={(e)=> setZip(e.target.value)}
            id="outlined-error"
            label="zip_code"
            defaultValue={detail.zip_code}
          />
        </div>
        <div>
          <TextField
            onChange={(e)=> setDistrict(e.target.value)}
            id="outlined-error"
            label="district"
            defaultValue={detail.district}

          />
          <TextField
            onChange={(e)=> setRegion(e.target.value)}
            id="outlined-error"
            label="region"
            defaultValue={detail.region}
          />
          <TextField
            onChange={(e)=> setCity(e.target.value)}
            id="outlined-error"
            label="country"
            defaultValue={detail.country}
          />
          <TextField
            onChange={(e)=> setPhone(e.target.value)}
            id="outlined-error"
            label="phone"
            defaultValue={detail.phone}
          />
          <TextField
            onChange={(e)=> setNote(e.target.value)}
            id="outlined-error"
            label="Note"
            defaultValue={detail.note}
          />
        </div>

        <Button  type={'submit'} variant="contained">Salva</Button>
      </FormControl>

    </div>
  );
}

export default FormData;