import React, {useState} from 'react';
import {Box, Modal,} from "@mui/material";
import FormData from "./FormData";

const ModalForm = ({open, handleClose,detail,url}) => {
  const style = {
    position: 'absolute',
    top: '50%',
    left: '50%',
    transform: 'translate(-50%, -50%)',
    width: 400,
    bgcolor: 'background.paper',
    boxShadow: 24,
    p: 4,
  };
  return (
    <div>
      <Modal
        open={open}
        onClose={handleClose}
      >
        <Box sx={style}>
          <FormData detail={detail} url={url}/>
        </Box>
      </Modal>
    </div>
  );
};

export default ModalForm;
